/*
 * Decompiled with CFR 0.152.
 */
package processing.video;

import java.io.File;
import processing.core.PApplet;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.io.OpenMovieFile;
import quicktime.io.QTFile;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.image.CSequence;
import quicktime.std.image.CodecComponent;
import quicktime.std.image.CompressedFrameInfo;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.QTImage;
import quicktime.std.movies.Movie;
import quicktime.std.movies.Track;
import quicktime.std.movies.media.SampleDescription;
import quicktime.std.movies.media.VideoMedia;
import quicktime.util.EncodedImage;
import quicktime.util.EndianOrder;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MovieMaker {
    public static final int RAW = 1918990112;
    public static final int ANIMATION = 1919706400;
    public static final int BASE = 1650553701;
    public static final int BMP = 1465011269;
    public static final int CINEPAK = 1668704612;
    public static final int COMPONENT = 2037741106;
    public static final int CMYK = 1668118891;
    public static final int GIF = 1734960672;
    public static final int GRAPHICS = 1936548640;
    public static final int H261 = 1748121137;
    public static final int H263 = 1748121139;
    public static final int H264 = QTUtils.toOSType((String)"avc1");
    public static final int JPEG = 1785750887;
    public static final int MS_VIDEO = 1836283491;
    public static final int MOTION_JPEG_A = 1835692129;
    public static final int MOTION_JPEG_B = 1835692130;
    public static final int SORENSON = 1398165809;
    public static final int VIDEO = 1919973985;
    public static final int WORST = 0;
    public static final int LOW = 256;
    public static final int MEDIUM = 512;
    public static final int HIGH = 768;
    public static final int BEST = 1023;
    public static final int LOSSLESS = 1024;
    private int width;
    private int height;
    private boolean readyForFrames;
    private int TIME_SCALE;
    private VideoMedia videoMedia;
    private Track videoTrack;
    private Movie movie;
    private QTFile movFile;
    private CSequence seq;
    private QTHandle imageHandle;
    private QDGraphics gw;
    private QDRect bounds;
    private ImageDescription imgDesc;
    private RawEncodedImage compressedImage;
    private int rate;
    private int keyFrameRate;
    private int codecType;
    private int codecQuality;
    private boolean temporalSupported;
    private PApplet parent;

    private final void initMovie(String string) {
        try {
            String string2 = this.parent.savePath(string);
            this.movFile = new QTFile(new File(string2));
            this.movie = Movie.createMovieFile((QTFile)this.movFile, (int)1414942532, (int)Integer.MIN_VALUE);
            int n = this.TIME_SCALE;
            this.videoTrack = this.movie.addTrack((float)this.width, (float)this.height, 0.0f);
            this.videoMedia = new VideoMedia(this.videoTrack, n);
            this.videoMedia.beginEdits();
            this.bounds = new QDRect(0, 0, this.width, this.height);
            int n2 = QTImage.getMaxCompressionSize((QDGraphics)this.gw, (QDRect)this.bounds, (int)this.gw.getPixMap().getPixelSize(), (int)this.codecQuality, (int)this.codecType, (CodecComponent)CodecComponent.anyCodec);
            this.imageHandle = new QTHandle(n2, true);
            this.imageHandle.lock();
            this.compressedImage = RawEncodedImage.fromQTHandle((QTHandleRef)this.imageHandle);
            this.seq = new CSequence(this.gw, this.bounds, this.gw.getPixMap().getPixelSize(), this.codecType, CodecComponent.bestFidelityCodec, this.codecQuality, this.codecQuality, this.keyFrameRate, null, 0);
            this.imgDesc = this.seq.getDescription();
            this.readyForFrames = true;
        }
        catch (QTException qTException) {
            if (qTException.errorCode() == -8961) {
                if (this.imageHandle == null) {
                    System.err.println("The specified codec is not supported, please ensure that the parameters are valid, and in the correct order.");
                } else {
                    this.temporalSupported = false;
                    this.readyForFrames = true;
                }
            }
            if (qTException.errorCode() == -47) {
                System.err.println("The movie file already exists.  Please delete it first.");
            }
            qTException.printStackTrace();
        }
    }

    public void addFrame() {
        this.parent.loadPixels();
        this.addFrame(this.parent.pixels, this.parent.width, this.parent.height);
    }

    public void addFrame(int[] nArray, int n, int n2) {
        if (this.readyForFrames) {
            RawEncodedImage rawEncodedImage = this.gw.getPixMap().getPixelData();
            int n3 = rawEncodedImage.getRowBytes() / 4;
            int[] nArray2 = new int[n3 * n2];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = 0;
                while (n5 < n2) {
                    nArray2[n4 + n5 * n3] = n4 < n ? nArray[n4 + n5 * n] : 0;
                    ++n5;
                }
                ++n4;
            }
            rawEncodedImage.setInts(0, nArray2);
            this.compressAndAdd();
        }
    }

    private final void compressAndAdd() {
        try {
            if (this.temporalSupported) {
                CompressedFrameInfo compressedFrameInfo = this.seq.compressFrame(this.gw, this.bounds, 4, this.compressedImage);
                int n = 0;
                if (compressedFrameInfo.getSimilarity() == 0) {
                    n = 1;
                }
                int n2 = n;
                this.videoMedia.addSample((QTHandleRef)this.imageHandle, 0, compressedFrameInfo.getDataSize(), this.TIME_SCALE / this.rate, (SampleDescription)this.imgDesc, 1, 1 - n2);
            } else {
                this.imgDesc = QTImage.fCompress((QDGraphics)this.gw, (QDRect)this.gw.getBounds(), (int)32, (int)this.codecQuality, (int)this.codecType, (CodecComponent)CodecComponent.anyCodec, null, (int)0, (EncodedImage)RawEncodedImage.fromQTHandle((QTHandleRef)this.imageHandle));
                int n = 1;
                this.videoMedia.addSample((QTHandleRef)this.imageHandle, 0, this.imgDesc.getDataSize(), this.TIME_SCALE / this.rate, (SampleDescription)this.imgDesc, 1, 1 - n);
            }
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void finish() {
        try {
            if (this.readyForFrames) {
                this.readyForFrames = false;
                this.videoMedia.endEdits();
                this.videoTrack.insertMedia(0, 0, this.videoMedia.getDuration(), 1.0f);
                OpenMovieFile openMovieFile = OpenMovieFile.asWrite((QTFile)this.movFile);
                this.movie.addResource(openMovieFile, -1, this.movFile.getName());
            }
        }
        catch (StdQTException stdQTException) {
            stdQTException.printStackTrace();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void dispose() {
        if (this.readyForFrames) {
            this.finish();
        }
        try {
            QTSession.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final /* synthetic */ void this() {
        this.TIME_SCALE = 1000;
        this.keyFrameRate = 15;
        this.temporalSupported = true;
    }

    public MovieMaker(PApplet pApplet, int n, int n2, String string) {
        this(pApplet, n, n2, string, 30, 1918990112, 768, 15);
    }

    public MovieMaker(PApplet pApplet, int n, int n2, String string, int n3) {
        this(pApplet, n, n2, string, n3, 1918990112, 768, 15);
    }

    public MovieMaker(PApplet pApplet, int n, int n2, String string, int n3, int n4, int n5) {
        this(pApplet, n, n2, string, n3, n4, n5, 15);
    }

    public MovieMaker(PApplet pApplet, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        this.this();
        this.parent = pApplet;
        this.width = n;
        this.height = n2;
        this.rate = n3;
        try {
            QTSession.open();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
        try {
            ImageDescription imageDescription = null;
            imageDescription = EndianOrder.isNativeLittleEndian() ? new ImageDescription(1111970369) : new ImageDescription(QDGraphics.kDefaultPixelFormat);
            imageDescription.setWidth(this.width);
            imageDescription.setHeight(this.height);
            this.gw = new QDGraphics(imageDescription, 0);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
        this.codecType = n4;
        this.codecQuality = n5;
        this.keyFrameRate = n6;
        this.initMovie(string);
        this.parent.registerDispose((Object)this);
    }
}

